package gov.va.med.mhv.integration.phr.service;

import gov.va.med.mhv.integration.phr.dao.PhrBaseDAO;
import gov.va.med.mhv.integration.phr.service.vistaweb.cache.CacheHandler;
import gov.va.med.mhv.integration.phr.stage.enumeration.StageMessageType;
import gov.va.med.mhv.integration.phr.stage.transfer.StageMessageControl;
import gov.va.med.mhv.integration.phr.transfer.QueryRequest;

import java.util.Date;

/**
 * @author DNS
 * 
 */
public abstract class AbstractBaseQueryService implements QueryService {

	protected StagingService stagingService = null;

	protected TrackingService trackingService = null;

	public void setStagingService(StagingService stagingService) {
		this.stagingService = stagingService;
	}

	public StagingService getStagingService() {
		return stagingService;
	}

	public void setTrackingService(TrackingService trackingService) {
		this.trackingService = trackingService;
	}

	public TrackingService getTrackingService() {
		return trackingService;
	}

	protected abstract StageMessageControl doQuery(QueryRequest request,
			QueryServiceResponse result);

	protected StageMessageControl getResponseMessage(QueryRequest request,
			QueryServiceResponse processingResult, String routingStatus) {

		StageMessageControl responseMessage = this.stagingService
				.findLatestStagingRequest(request.getIcn(),
						request.getStationNumber(),
						RefreshDataService.messageName,
						request.getExtractType());

		if (responseMessage == null) {
			responseMessage = new StageMessageControl(DataService.messageName,
					(long) processingResult.getRecordCount(), routingStatus,
					StageMessageType.RESPONSE, request.getIcn(),
					request.getStationNumber(), request.getExtractType(),
					request.getStartDate(), request.getEndDate());
		}

		// @DNS - JAZZ 110617
		// The issue here is that the request / response message control IDs
		// are initialized during construction to a value of OL. If we reset
		// them here to the value of the identity of the object, if it's a
		// new object that hasn't been persisted yet, that value will be null
		// and may result in a null pointer exception. Better to leave the value
		// as 0L until the ID has an actual value. This value will be assigned
		// during the insert process in the DAO.

		// // initiate the response message control identifier from the request.
		// responseMessage.setRequestMsgCtrlId(request.getRequestMsgCtrlId());
		//
		// // setup a request id if none was provided
		// if (request.getRequestMsgCtrlId() == 0)
		// responseMessage.setRequestMsgCtrlId(responseMessage.getId());
		//
		// responseMessage.setResponseMsgCtrlId(responseMessage.getId());

		return responseMessage;
	}

	public QueryServiceResponse process(QueryRequest request) {

		QueryServiceResponse result = new QueryServiceResponse(
				QueryServiceResponse.OK);
		Date queryStartTime = new Date();

		StageMessageControl stageMessage = null;

		// update the extract log with the progress
		try {
			stageMessage = doQuery(request, result);

			// update the response message and track the progress
			stageMessage.setMessageStatus(result.getStatus());
			stageMessage.setMessageName(DataService.messageName);
			stageMessage.setCreatedDate(queryStartTime);

			// include the status and any error message if the extract status is
			// 'ERROR' information
			stageMessage.setExtractStatus(result.getStatus());
			if ("ERROR".equalsIgnoreCase(stageMessage.getExtractStatus())) {
				stageMessage.setErrorMessage(result.getDescription());
			}

			stageMessage.setEndDate(new Date());

		} catch (Exception ex) {
			result.setStatus(QueryServiceResponse.ERROR);
			result.setDescription(String.format(
					"Error staging message status: %s", ex.getMessage()));

			if (stageMessage != null) {
				stageMessage.setExtractStatus(result.getStatus());
				stageMessage.setErrorMessage(result.getDescription());
			}
		} finally {
			if (stageMessage != null) {
				this.stagingService.stageRequest(stageMessage);
			}
		}

		return result;
	}

	protected void updateCacheHandler(QueryRequest request, PhrBaseDAO phrDao) {
		CacheHandler.getInstance().setIcn(request.getIcn());
		CacheHandler.getInstance().setFacilityInfo(phrDao.fetchFacilityInfoIds(request.getIcn()));
		CacheHandler.getInstance().setPhrfacilitycontrol(phrDao.fetchPhrFacilityControlIds(request.getIcn()));
		CacheHandler.getInstance().setPatientId(phrDao.fetchPatientId(request.getIcn()));
	}
}
